﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="WnioskiORekrutacje.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.WnioskiORekrutacje" %>

<!DOCTYPE html>


<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Wnioski o rekrutację</title>
    <link href="../Web.css?2" type="text/css" rel="stylesheet" />
    <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />
    <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/i18n/jquery.ui.datepicker-pl.js" type="text/javascript"></script>
    <script src="../jquery/jquery.blockUI.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {
            $('#tbDataOd').datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, showAnim: '', yearRange: '1970:2060', showOn: 'button', buttonImage: '../img/calendar.gif', buttonImageOnly: true });
            $('#tbDataDo').datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, showAnim: '', yearRange: '1970:2060', showOn: 'button', buttonImage: '../img/calendar.gif', buttonImageOnly: true });
            
            $("#tbDataOd").datepicker("option", "dateFormat", 'yy-mm-dd');
            $("#tbDataDo").datepicker("option", "dateFormat", 'yy-mm-dd');
            
            $("#btnOdswiez").button({ icons: { primary: 'ui-icon-refresh' } });
            $("#btnDodaj").button({ icons: { primary: 'ui-icon-plusthick' } });
            $(".btnOtworzGrid").button({ icons: { primary: 'ui-icon-folder-open' } });

          if (!$("#btnDodaj").attr('href')) {
            $("#btnDodaj").addClass("ui-state-disabled");
            $("#btnDodaj").prop("onclick", null);
          }
        });
    </script>
</head>
<body id="body" style="font-size: 8pt;" runat="server">
    <form id="form1" runat="server">
        <div>
            <asp:Label ID="lblError" runat="server" EnableViewState="false"></asp:Label>
            <asp:Label ID="lblKomunikat" runat="server" EnableViewState="true"></asp:Label>
            <table class="bodyLRT0" cellspacing="0" cellpadding="0" width="100%" border="0">
                <tr>
                    <td colspan="4">
                        <asp:Label ID="lblNaglowek" runat="server" Style="font-size: 12pt; font-weight: bold">Wnioski o rekrutację</asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%" valign="bottom">
                        <small>Jednostka</small><br />
                        <asp:DropDownList ID="ddlJednostka" runat="server" Width="95%"></asp:DropDownList>
                    </td>
                    <td style="width: 25%" valign="bottom">
                        <small>
                            <asp:Label ID="Label3" runat="server">Stanowisko</asp:Label></small><br />
                        <asp:TextBox ID="tbStanowisko"  Width="95%" runat="server"></asp:TextBox>
                    </td>
                    <td style="width: 25%" valign="bottom">
                        <small>Status</small><br />
                        <asp:DropDownList ID="ddlStatus"  Width="95%" runat="server">
                        </asp:DropDownList>
                    </td>
                    <td style="width: 25%; text-align: right" valign="bottom">
                    </td>
                </tr>
                <tr>
                    <td valign="bottom">
                        <small>od (rrrr-mm-dd)</small><br />
                        <asp:TextBox ID="tbDataOd" Width="80%" runat="server"></asp:TextBox>
                    </td>
                    <td valign="bottom">
                        <small>do (rrrr-mm-dd)</small><br />
                        <asp:TextBox ID="tbDataDo" Width="80%" runat="server"></asp:TextBox>
                    </td>
                    <td valign="bottom">
                    </td>
                    <td style="text-align: right" valign="bottom">
                        <small></small>
                        <br />
                        <asp:LinkButton ID="btnOdswiez" runat="server" Text="Odśwież" Width="90px" CssClass="aspButton" OnClick="btnOdswiez_Click"></asp:LinkButton>
                    </td>
                </tr>
            </table>
        </div>
        <div>
            <asp:LinkButton ID="btnDodaj" runat="server" Text="Dodaj" Width="90px" CssClass="aspButton" OnClick="btnDodaj_Click" ></asp:LinkButton>
            <div id="divLiczbaWierszy" runat="server" class="Table" style="width: 100%; display: none; position: relative; height: 23px; background-color: White;">
                <div style="float: left; position: absolute; bottom: 2px;">
                    <asp:Label ID="lblLiczbaWierszy" runat="server"></asp:Label>
                </div>
            </div>
            <asp:GridView ID="gvListy" runat="server" CssClass="aspGrid" Width="100%" AutoGenerateColumns="False" AllowSorting="True" DataSourceID="sdsListy" DataKeyNames="ID_WNIOSKU,ID_MPZ,JEDNOSTKA,ID_STANOWISKA,STANOWISKO,ID_PRZYCZYNY,PRZYCZYNA,LICZBA_WAKATOW,ID_PRACOWNIKA_WAKAT,PRACOWNIK_WAKAT,WYNAGRODZENIE_OD,WYNAGRODZENIE_DO,DATA_ZATRUDNIENIA,ID_RODZAJU_REKRUTACJI,RODZAJ_REKRUTACJI,UZASADNIENIE_REKRUTACJI,STATUS,STATUS_NAZWA,UZASADNIENIE,OPINIA_AP,OPINIA_PZ,OPINIA_ZA,ID_ETAPU,DATA_WYPELNIENIA,DATA_AKCEPTACJI_KJ,DATA_AKCEPTACJI_AP,DATA_AKCEPTACJI_PZ,DATA_AKCEPTACJI_ZA,KJ,PAK,AK,AP,PRW,PZ,ZA,HR,DO_PZ_ZA" AllowPaging="True" OnRowCommand="gvListy_RowCommand">
                <Columns>
                    <asp:TemplateField ShowHeader="False">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbOtworzGrid" class="btnOtworzGrid" runat="server" CausesValidation="false" CommandName="OTWORZ" CommandArgument='<%# Container.DataItemIndex %>' Text="Otwórz"></asp:LinkButton>
                        </ItemTemplate>
                        <ItemStyle VerticalAlign="Middle" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="JEDNOSTKA" HeaderText="Jednostka" SortExpression="JEDNOSTKA" />
                    <asp:BoundField DataField="STANOWISKO" HeaderText="Stanowisko" SortExpression="STANOWISKO" />
                    <asp:BoundField DataField="PRZYCZYNA" HeaderText="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Przyczyna&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" SortExpression="PRZYCZYNA" />
                    <asp:BoundField DataField="LICZBA_WAKATOW" HeaderText="Liczba wakatów" SortExpression="LICZBA_WAKATOW" />
                    <asp:TemplateField HeaderText="Wynagrodz.&lt;br/&gt; od" SortExpression="WYNAGRODZENIE_OD">
                        <EditItemTemplate>
                            <asp:TextBox ID="TextBox1" runat="server" Text='<%# Bind("WYNAGRODZENIE_OD") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="lblWynagrodzenieOd" runat="server" Text='<%# Bind("WYNAGRODZENIE_OD", "{0:f2}") %>'></asp:Label>
                        </ItemTemplate>
                        <ControlStyle Width="60px" />
                        <HeaderStyle Width="60px" />
                        <ItemStyle Width="60px" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Wynagrodz.&lt;br/&gt; do" SortExpression="WYNAGRODZENIE_DO">
                        <EditItemTemplate>
                            <asp:TextBox ID="TextBox2" runat="server" Text='<%# Bind("WYNAGRODZENIE_DO") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="lblWynagrodzenieDo" runat="server" Text='<%# Bind("WYNAGRODZENIE_DO", "{0:f2}") %>'></asp:Label>
                        </ItemTemplate>
                        <ControlStyle Width="60px" />
                        <HeaderStyle Width="60px" />
                        <ItemStyle Width="60px" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Data zatrudnienia" SortExpression="DATA_ZATRUDNIENIA">
                        <EditItemTemplate>
                            <asp:TextBox ID="TextBox2" runat="server" Text='<%# Bind("DATA_ZATRUDNIENIA") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="lblDataZatrudnienia" runat="server" Text='<%# Bind("DATA_ZATRUDNIENIA", "{0:yyyy-MM-dd}") %>'></asp:Label>
                        </ItemTemplate>
                        <ControlStyle Width="70px" />
                        <HeaderStyle Width="70px" />
                        <ItemStyle Width="70px" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="RODZAJ_REKRUTACJI" HeaderText="Rodzaj rekrutacji" SortExpression="RODZAJ_REKRUTACJI" />
                    <asp:BoundField DataField="STATUS_NAZWA" HeaderText="Status" SortExpression="STATUS_NAZWA" />
                    <asp:BoundField DataField="DATA_WYPELNIENIA" HeaderText="Data wypełnienia" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_WYPELNIENIA" />
                    <asp:BoundField DataField="WYPELNIAJACY" HeaderText="Wypełniający" SortExpression="WYPELNIAJACY" />
                    <asp:BoundField DataField="DATA_AKCEPTACJI_KJ" HeaderText="Data akceptacji KJ" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_AKCEPTACJI_KJ" />
                    <asp:BoundField DataField="AKCEPTUJACY_KJ" HeaderText="Akceptujący KJ" SortExpression="AKCEPTUJACY_KJ" />
                    <asp:BoundField DataField="DATA_AKCEPTACJI_PZ" HeaderText="Data akceptacji PZ" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_AKCEPTACJI_PZ" />
                    <asp:BoundField DataField="DATA_ODRZUCENIA_PZ" HeaderText="Data odrz. PZ" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_ODRZUCENIA_PZ" />
                    <asp:BoundField DataField="AKCEPTUJACY_PZ" HeaderText="Akceptujący PZ" SortExpression="AKCEPTUJACY_PZ" />
                    <asp:BoundField DataField="DATA_AKCEPTACJI_ZA" HeaderText="Data akceptacji ZA" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_AKCEPTACJI_ZA" />
                    <asp:BoundField DataField="DATA_ODRZUCENIA_ZA" HeaderText="Data odrz. ZA" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_ODRZUCENIA_ZA" />
                    <asp:BoundField DataField="AKCEPTUJACY_ZA" HeaderText="Akceptujący ZA" SortExpression="AKCEPTUJACY_ZA" />
                    <asp:BoundField DataField="DATA_ANULOWANIA" HeaderText="Data anulowania" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_ANULOWANIA" />
                    <asp:BoundField DataField="ANULUJACY" HeaderText="Anulujący" SortExpression="ANULUJACY" />
                </Columns>
                <PagerSettings Position="Top" />
                <RowStyle CssClass="TableItem" />
                <SelectedRowStyle CssClass="TableItemSelected" />
                <HeaderStyle CssClass="TableHeader" />
                <AlternatingRowStyle CssClass="TableItemAlt" />
            </asp:GridView>
            <asp:SqlDataSource ID="sdsListy" runat="server" ProviderName="System.Data.SqlClient" SelectCommand="WNIOSKI_O_REKRUTACJE_LIST" SelectCommandType="StoredProcedure" ConnectionString="" CancelSelectOnNullParameter="False" OnSelected="sdsListy_Selected">
                <SelectParameters>
                    <asp:SessionParameter Name="P_ID_FIRMY" SessionField="ID_FIRMY" />
                    <asp:ControlParameter ControlID="tbStanowisko" Name="P_STANOWISKO" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
                    <asp:ControlParameter ControlID="tbDataOd" Name="P_DATA_OD" PropertyName="Text" Type="DateTime" />
                    <asp:ControlParameter ControlID="tbDataDo" Name="P_DATA_DO" PropertyName="Text" Type="DateTime" />
                    <asp:ControlParameter ControlID="ddlStatus" Name="P_STATUS" PropertyName="SelectedValue"
                        Type="String" />
                    <asp:ControlParameter ControlID="ddlJednostka" Name="P_ID_MPZ" PropertyName="SelectedValue" />
                </SelectParameters>
            </asp:SqlDataSource>
        </div>
    </form>
</body>
</html>

